<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Numbers\V2\RegulatoryCompliance\Bundle;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class BundleCopyList extends ListResource {
    /**
     * Construct the BundleCopyList
     *
     * @param Version $version Version that contains the resource
     * @param string $bundleSid The unique string that identifies the resource.
     */
    public function __construct(Version $version, string $bundleSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['bundleSid' => $bundleSid, ];

        $this->uri = '/RegulatoryCompliance/Bundles/' . \rawurlencode($bundleSid) . '/Copies';
    }

    /**
     * Create the BundleCopyInstance
     *
     * @param array|Options $options Optional Arguments
     * @return BundleCopyInstance Created BundleCopyInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(array $options = []): BundleCopyInstance {
        $options = new Values($options);

        $data = Values::of(['FriendlyName' => $options['friendlyName'], ]);

        $payload = $this->version->create('POST', $this->uri, [], $data);

        return new BundleCopyInstance($this->version, $payload, $this->solution['bundleSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Numbers.V2.BundleCopyList]';
    }
}